<style>
  table {
    width: 100%; /* 或者具体的像素值，例如：1200px */
    table-layout: fixed; /* 保持列宽固定 */
  }
  th, td {
    word-wrap: break-word; /* 允许文本换行 */
  }
  .delline{
    text-decoration:line-through;
  }
  .yellowFill{
    background-color: yellow;
  }
</style>

<br>
<br>
<br>

<div  style="text-align: center;font-size: 70px;">
SunVote B200W <br>MQTT通讯协议
</div>
<br>
<br>
<br>
<br>
<div  style="text-align: center;font-size: 30px;">
Ver 1.0.1
</div>
<br>
<br>
<br>
<br>
<br>
<br>

<div  style="text-align: center;font-size: 30px;">
长沙中天电子设计开发有限公司
</div>

<br>

<div  style="text-align: center;font-size: 30px;">
二〇二四年十月
</div>

<br>
<br>
<br>
<br>

文件控制：

文件名：SunVote B200W MQTT通讯协议

起草人：刘琴

最新版本作者： 刘琴
<br>
| 文档版本 | 日期 | 作者 | 版本说明 |
|---|---|---|---|
|1.0.1| 2024年10月22日|刘琴|1.  初始版|

<br>
<br>

[TOC]

# SunVote B200W MQTT通讯协议
# 功能说明

## 主题说明
\${baseSN}为指定的基站的SN编码，不能为空，接收基站反馈数据需要订阅对应基站SN的接收主题。
### 发布的主题
应用程序发布的主题，基站订阅
/client/\${baseSN}/send
/client/multiBase/send

### 订阅的主题
应用程序订阅的主题，基站发布
/basestation/\\${baseSN}/receive
/basestation/multiBase/receive 

## 指令说明
|指令功能标识	|说明	|约束|
|---|---|---|
|get|	待机状态下获取参数属性状态及数据	|待机状态|
|set|	待机状态下设置参数属性状态及数据	|待机状态|
|start|	运行一个单进程业务实例（函数）	|待机状态|
|stop|	停止一个单进程业务实例（函数）	|待机状态|
|rtXXX|	在线状态下可实时执行方法及函数	||

## 事件说明
|事件标识|	说明|	约束|
|---|---|---|
|sEvtXXX|系统事件	|自动返回|
|fEvtXXX|指令事件	|调用对应指令后返回|

## 数据格式约定
- 数据格式统一为**Json**格式，发送接收消息编码统一为**UTF-8**
- Json通用格式如下：

```json
  {
    "fun":"xxx", 
    "dataTag":"xxx", 
    "data":{    
       //内容
    }
  }
```

|参数	|说明	|约束|
|---|---|---|
|fun|	指令或事件名称||
|dataTag|	数据标签，用于对应收发数据|长度不超过4，可为0-9a-zA-Z的组合|
|data|	数据内容|对象或者数组，可为空|

<font color="red">注意：基站接收指令数据单次不超过2K长度，在指定键盘发送指令时，如果指令长度超出限制，建议将指令进行拆分，分次发送，如果是所有键盘执行的指令，可将keySns设为空数组不使用指定键盘的模式</font>


## 功能速查一览表
### 公共方法
可以在多种业务中调用的通用方法
|功能归类|功能|API指令|指令/系统事件|
|---|---|---|---|
|停止投票|可停止通过调用startXXX启动的答题业务|[stopKpVote](#stopkpvote)|[sEvtStateCode](#sevtstatecode)||

### 公共事件
无需调用指令，自动返回的事件
|功能归类|功能|API指令|指令/系统事件|
|---|---|---|---|
|公共事件|指令接收状态|-|[sEvtStateCode](#sevtstatecode)|
|公共事件|基站连接状态变化|-|[sEvtBsConnectState](#sevtbsconnectstate)|
|公共事件|基站信道冲突|-|[sEvtBsChannelConflict](#sevtbschannelconflict)|
|公共事件|键盘上线通知|-|[sEvtBsKpOnlineMsg](#sevtbskponlinemsg)|
|公共事件|键盘刷卡事件|-|[sEvtBsNfcResults](#sevtbsnfcresults)|
|公共事件|键盘待机实时按键反馈|-|[sEvtKpRtFeedback](#sevtkprtfeedback)|

### 基站管理
|功能归类|功能|API指令|指令/系统事件|
|---|---|---|---|
|基站连接 - 获取在线基站|主动获取在线基站信息<br>不确定基站SN时|[getBsOnlineState](#getbsonlinestate)|[fEvtBsOnlineState](#fevtbsonlinestate)||
|基站连接 - 主动获取状态|主动获取基站连接状态|[getBsConnectState](#getbsconnectstate)|[sEvtBsConnectState](#sevtbsconnectstate)||
|基站连接 - 自动获取状态|基站连接变化系统通知|-|[sEvtBsConnectState](#sevtbsconnectstate)||
|基站授时|对基站授时用于校准时间|[timeSync](#timesync)|[sEvtStateCode](#sevtstatecode)||
|键盘上线通知|单个键盘上线系统通知|-|[sEvtBsKpOnlineMsg](#sevtbskponlinemsg)||
|识别设置 - 基站型号|读取基站型号|[getBsModel](#getbsmodel)|[fEvtBsModel](#fevtbsmodel)|
|识别设置 - 固件版本|获取基站固件版本|[getBsFWVersion](#getbsfwversion)|[fEvtBsFWVersion](#fevtbsfwversion)|
|组网设置 - 组网模式|获取基站组网模式|[getBsNetworkMode](#getbsnetworkmode)|[fEvtBsNetworkMode](#fevtbsnetworkmode)|
|组网设置 - 配对码|获取基站配对码|[getBsPairCode](#getbspaircode)|[fEvtBsPairCode](#fevtbspaircode)|
|组网设置 - 刷卡配对状态|获取刷卡配对状态|[getBsNfcLogin](#getbsnfclogin)|[fEvtBsNfcLogin](#fevtbsnfclogin)|
||设置刷卡配对状态|[setBsNfcLogin](#setbsnfclogin)|[fEvtBsNfcLogin](#fevtbsnfclogin)||
|组网设置 - 工作信道|获取基站工作信道|[getBsChannel](#getbschannel)|[fEvtBsChannel](#fevtbschannel)|
||设置基站工作信道|[setBsChannel](#setbschannel)|[fEvtBsChannel](#fevtbschannel)||
||读取已被占用信道|[getBsRFIChannel](#getbsrfichannel)|[fEvtBsRFIChannel](#fevtbsrfichannel)||
|登录设置 - 登录名称|获取基站登录名称|[getBsSSID](#getbsssid)|[fEvtBsSSID](#fevtbsssid)|
||设置基站登录名称|[setBsSSID](#setbsssid)|[fEvtBsSSID](#fevtbsssid)||
|登录设置 - 登录密码|获取基站登录密码|[getBsLoginPwd](#getbsloginpwd)|[fEvtBsLoginPwd](#fevtbsloginpwd)|
||设置基站登录密码|[setBsLoginPwd](#setbsloginpwd)|[fEvtBsLoginPwd](#fevtbsloginpwd)||
|登录设置 - 基站登录状态|获取基站登录状态|[getBsLoginState](#getbsloginstate)|[fEvtBsLoginState](#fevtbsloginstate)|
||设置基站登录状态|[setBsLoginState](#setbsloginstate)|[fEvtBsLoginState](#fevtbsloginstate)||
|配对模式 - 快速配对|启动基站快速配对|[startBsFastPair](#startbsfastpair)|[sEvtStateCode](#sevtstatecode)<br>[sEvtBsKpOnlineMsg](#sevtbskponlinemsg)|
||停止基站快速配对|[stopBsFastPair](#stopbsfastpair)|[sEvtStateCode](#sevtstatecode)|
|白名单模式 - 白名单管理|获取白名单|[getBsWhitelist](#getbswhitelist)|[fEvtBsWhitelist](#fevtbswhitelist)|
||设置白名单|[setBsWhitelist](#setbswhitelist)|[sEvtStateCode](#sevtstatecode)<br>[fEvtSetBsWhitelist](#fevtsetbswhitelist)|
||清空白名单|[clearBsWhitelist](#clearbswhitelist)|[sEvtStateCode](#sevtstatecode)<br>[fEvtBsWhitelist](#fevtbswhitelist)|
||增加白名单|[addBsWhitelist](#addbswhitelist)|[sEvtStateCode](#sevtstatecode)<br>[fEvtAddBsWhitelist](#fevtaddbswhitelist)<br>[fEvtBsWhitelist](#fevtbswhitelist)|
||删除白名单|[delBsWhitelist](#delbswhitelist)|[sEvtStateCode](#sevtstatecode)<br>[fEvtDelBsWhitelist](#fevtdelbswhitelist)<br>[fEvtBsWhitelist](#fevtbswhitelist)|
|基站加密 - 软件狗|获取基站软件狗|[getBsSoftwareKey](#getbssoftwarekey)|[fEvtBsSoftwareKey](#fevtbssoftwarekey)|
||设置基站软件狗|[setBsSoftwareKey](#setbssoftwarekey)|[fEvtBsSoftwareKey](#fevtbssoftwarekey)|
|网络设置 - TCP/IP参数|获取TCP/IP参数|[getBsTcpipParams](#getbstcpipparams)|[fEvtBsTcpipParams](#fevtbstcpipparams)|
||设置TCP/IP参数|[setBsTcpipParams](#setbstcpipparams)|[fEvtBsTcpipParams](#fevtbstcpipparams)||
|网络设置 - MQTT参数|获取MQTT参数|[getBsMqttParams](#getbsmqttparams)|[fEvtBsMqttParams](#fevtbsmqttparams)|
||设置MQTT参数|[setBsMqttParams](#setbsmqttparams)|[fEvtBsMqttParams](#fevtbsmqttparams)||
### 键盘管理
|功能归类|功能|API指令|指令事件|
|---|---|---|---|
|交互设置 - 用户实时提示信息|实时设置提示反馈信息|[rtSetKpUserPrompt](#rtsetkpuserprompt)|[sEvtStateCode](#sevtstatecode)<br>[fEvtSetKpUserPrompt](#fevtsetkpuserprompt)|
|在线状态获取|开启扫描在线键盘|[startGetKpOnline](#startgetkponline)|[sEvtStateCode](#sevtstatecode)<br>[fEvtKpOnlineMsg](#fevtkponlinemsg)|
||停止扫描在线键盘|[stopGetKpOnline](#stopgetkponline)|[sEvtStateCode](#sevtstatecode)|
|维护功能 - 遥控功能|遥控键盘休眠|[remoteKpSleep](#remotekpsleep)|[sEvtStateCode](#sevtstatecode)|
### 绑定
|功能归类|功能|API指令|指令事件|
|---|---|---|---|
|无线绑定|设置绑定信息到键盘|[rtSetKpBindingInfo](#rtsetkpbindinginfo)|[sEvtStateCode](#sevtstatecode)<br>[fEvtKpBindingInfo](#fevtkpbindinginfo)|
||清除键盘绑定信息|[clearKpBindingInfo](#clearkpbindinginfo)|[sEvtStateCode](#sevtstatecode)<br>[fEvtClearKpBindingInfo](#fevtclearkpbindinginfo)|
### 签到
|功能归类|功能|API指令|指令事件|
|---|---|---|---|
|同步签到|启动同步签到|[startKpSignIn](#startkpsignin)|[sEvtStateCode](#sevtstatecode)<br>[fEvtKpSignIn](#fevtkpsignin)|
||停止同步签到|[stopKpVote](#stopkpvote)|[sEvtStateCode](#sevtstatecode)|
|随时签到|启动随时签到|[rtStartKpSignIn](#rtstartkpsignin)|[sEvtStateCode](#sevtstatecode)<br>[fEvtKpSignIn](#fevtkpsignin)|
||停止随时签到|[rtStopKpSignIn](#rtstopkpsignin)|[sEvtStateCode](#sevtstatecode)|
||实时PIN签到授权|[rtSetKpLoginAllowed](#rtsetkploginallowed)|[sEvtStateCode](#sevtstatecode)<br>[fEvtKpLoginAllowed](#fevtkploginallowed)|
### 按键反馈
|功能归类|功能|API指令|指令事件|
|---|---|---|---|
|判断题|启动判断题答题|[startQATrueFalse](#startqatruefalse)|[sEvtStateCode](#sevtstatecode)<br>[fEvtQATrueFalse](#fevtqatruefalse)|
||停止判断题答题|[stopKpVote](#stopkpvote)|[sEvtStateCode](#sevtstatecode)|
|选择题|启动选择题答题|[startQAChoice](#startqachoice)|[sEvtStateCode](#sevtstatecode)<br>[fEvtQAChoice](#fevtqachoice)|
||停止选择题答题|[stopKpVote](#stopkpvote)|[sEvtStateCode](#sevtstatecode)|
|数字题|启动数字题答题|[startQANum](#startqanum)|[sEvtStateCode](#sevtstatecode)<br>[fEvtQANum](#fevtqanum)|
||停止数字题答题|[stopKpVote](#stopkpvote)|[sEvtStateCode](#sevtstatecode)|
|抢答题|启动抢答题答题|[startQAQuicker](#startqaquicker)|[sEvtStateCode](#sevtstatecode)<br>[fEvtQAQuicker](#fevtqaquicker)|
||停止抢答题答题|[stopKpVote](#stopkpvote)|[sEvtStateCode](#sevtstatecode)|
|待机实时反馈|设置待机实时反馈状态|[setKpStbResponse](#setkpstbresponse)|[fEvtKpStbResponse](#fevtkpstbresponse)<br>[sEvtKpRtFeedback](#sevtkprtfeedback)|
||获取待机实时反馈状态|[getKpStbResponse](#getkpstbresponse)|[fEvtKpStbResponse](#fevtkpstbresponse)|
### 在线测验
|功能归类|功能|API指令|指令事件|
|---|---|---|---|
|标准测验|启动标准测验|[startKpExam](#startkpexam)|[sEvtStateCode](#sevtstatecode)<br>[fEvtKpExam](#fevtkpexam)<br>[fEvtFinalSubmit](#fevtfinalsubmit)|
||停止标准测验|[stopKpVote](#stopkpvote)|[sEvtStateCode](#sevtstatecode)|
||允许键盘提交后退回修改|[rtAllowEdited](#rtkpallowedited)|[sEvtStateCode](#sevtstatecode)<br>[fEvtFinalSubmit](#fevtfinalsubmit)|
|多科测验|启动多科测验|[startKpMultiExam](#startkpmultiexam)|[sEvtStateCode](#sevtstatecode)<br>[fEvtKpExam](#fevtkpexam)<br>[fEvtFinalSubmit](#fevtfinalsubmit)|
||停止标准测验|[stopKpVote](#stopkpvote)|[sEvtStateCode](#sevtstatecode)|
|自主录分|启动自主录分|[startKpScoreInput](#startkpscoreinput)|[sEvtStateCode](#sevtstatecode)<br>[fEvtKpScore](#fevtkpscore)<br>[fEvtFinalSubmit](#fevtfinalsubmit)|
||停止自主录分|[stopKpVote](#stopkpvote)|[sEvtStateCode](#sevtstatecode)|

## 公共方法
### stopKpVote
- **主题**: /client/\${baseSN}/send
- **功能描述**：通用停止键盘答题方法，可以停止如同步签到、按键反馈、在线测验中调用startXXX方法启动的业务
- **参数说明**

|参数名|类型|限制|非空|说明|
|-----|-----|-----|-----|-----|
|fun|string|-|是|事件类型|
|dataTag|string||否|数据包标识，不需要时可传空字符串|

- **示例代码**
```json
{
    "fun":"stopKpVote",
    "dataTag":"1"
}
```

## 公共事件
### sEvtBsConnectState
- **主题**: /basestation/\${baseSN}/receive
- **功能描述**：基站连接成功时返回基站型号和基站SN,基站从已连接状态断开返回连接断开
- **参数说明**

|参数名|类型|限制|非空|说明|
|-----|-----|-----|-----|-----|
|fun|string|-|是|事件类型|
|dataTag|string||否|数据包标识，不需要时可传空字符串|
|data|object|-|是|传送参数的对象|
|+baseModel|int||否|基站的型号码|
|+modelName|string||否|基站的型号名称|
|+state|int||是|基站的连接状态<br>1-已连接<br>2-连接断开|
|+version|string||否|基站固件版本|

- **示例代码**
```json
//连接成功
{
    "fun":"sEvtBsConnectState",
    "dataTag":"1",
    "data":{  
        "state":1,      
        "baseModel":218,
        "modelName":"B200",
        "version":"1.0.3"
    }
}
//连接断开
{
    "fun":"sEvtBsConnectState",
    "dataTag":"1",
    "data":{        
        "state":2
    }
}
```
### sEvtBsChannelConflict
- **主题**: /basestation/\${baseSN}/receive
- **功能描述**：基站信道冲突时主动上报，应用程序可根据实际业务修改基站信道
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|事件名称|
|dataTag|string|-|否|数据包标识，不需要时可传空字符串|
|data|object|-|是|传送参数的对象|
|+value|int||是|有冲突的信道|

- **示例代码**
```json
{
    "fun":"sEvtBsChannelConflict",
    "dataTag":"1",
    "data":{        
        "value":5   //信道5有多个基站使用
    }
}
```
### sEvtBsNfcResults
- **主题**: /basestation/\${baseSN}/receive
- **功能描述**：键盘刷卡时主动上报，如果超出基站容量会上报失败
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|事件名称|
|dataTag|string|-|否|数据包标识，不需要时可传空字符串|
|data|object|-|是|传送参数的对象|
|+keySn|string||是|刷卡的键盘SN|
|+cardType|int||是|刷卡的键盘类型<br>1-NFC类型<br>2-M1类型|
|+value|int||是|刷卡的状态<br>1-成功<br>2-失败|

- **示例代码**
```json
{
    "fun":"sEvtBsNfcResults",
    "dataTag":"1",  //不需要时可传空字符串
    "data":{ 
        "keySn":"1234567890",    
        "cardType":1,   
        "value":1   
    }
}
```

### sEvtBsKpOnlineMsg
- **主题**: /basestation/\${baseSN}/receive
- **功能描述**：键盘上线通知，主动上报,键盘升级成功后也会上报
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|事件名称|
|dataTag|string|-|否|数据包标识|
|data|object|-|是|传送参数的对象|
|+keySn|string||是|键盘SN|
|+version|string||是|键盘固件版本|
|+model|int||是|键盘型号|

- **示例代码**
```json
{
    "fun":"sEvtBsKpOnlineMsg",
    "dataTag":"1",
    "data":{ 
        "keySn":"1234567890",
        "version":"1.0.0",
        "model":67
    }
}
```
### sEvtKpRtFeedback
- **主题**: /basestation/\${baseSN}/receive
- **功能描述**：开启键盘实时反馈后，键盘按键时上报
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|事件名称|
|dataTag|string|-|否|数据包标识|
|data|array|-|是|传送参数的对象数组|
|++keySn|string||是|键盘SN|
|++keyValue|string||是|键盘提交的按键值|
|++voltage|double||是|键盘电量|
|++retryCount|int||是|键盘提交数据的重发次数|

- **示例代码**
```json
{
    "fun":"sEvtKpRtFeedback",
    "dataTag":"1",
    "data":[{ 
        "keySn":"1234567890",
        "keyValue":"A",
        "voltage":2.6,
        "retryCount":1
    }]
}
```
### sEvtStateCode
- **主题**: /basestation/\${baseSN}/receive
- **功能描述**：返回基站接收指令状态信息
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|事件名称|
|dataTag|string|-|否|数据包标识|
|data|object|-|是|传送参数的对象|
|+funName|string||是|指令名称|
|+code|string||是|状态码，含义见下表|

|状态码|说明|
|---|---|
|0|指令收取成功|
|10001|不能正确解析的JSON数据|
|10002|解析JSON错误|
|10003|下发数据包超长|
|20001|基站未连接|
|20002|功能不支持|
|20003|基站SN格式不正确|
|20004|参数错误|
|20005|dataTag错误|
|20006|键盘SN错误|
|20007|tip参数错误|
|20008|value参数错误|
|30001|基站在答题中|
|30002|基站忙(内存不足)|
|30003|基站执行失败|
|40001|升级功能只能支持一个基站|
|50001|此功能必须指定基站|
|60001|此功能必须指定键盘SN|
|70001|没有字库|

- **示例代码**
```json
{
    "fun":"sEvtStateCode",
    "dataTag":"1",
    "data":{ 
        "funName":"startKpSignIn",
        "code":"20005"
    }
}
```
## 基站管理
### 基站连接
#### 方法
##### getBsOnlineState
- **主题**：<span class="yellowFill">/client/multiBase/send</span>
- **功能描述**：主动获取所有在线基站信息,在线基站回复
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|固定指令名称|
|dataTag|string|-|否|数据包标识|
- **示例代码**
```json
{
  "fun":"getBsOnlineState",
  "dataTag":"1"
}
```

##### getBsConnectState
- **主题**：/client/\${baseSN}/send
- **功能描述**：主动获取基站连接状态
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|固定指令名称|
|dataTag|string|-|否|数据包标识|
- **示例代码**
```json
{
  "fun":"getBsConnectState",
  "dataTag":"1"
}
```
#### 事件
##### [sEvtBsConnectState](#sevtbsconnectstate)
参见基站连接变化系统通知

##### fEvtBsOnlineState
- **主题**: <span class="yellowFill">/basestation/multiBase/receive</span>
- **功能描述**：基站在线返回基站型号和基站SN
- **参数说明**

|参数名|类型|限制|非空|说明|
|-----|-----|-----|-----|-----|
|fun|string|-|是|事件类型|
|dataTag|string|-|否|数据包标识，不需要时可传空字符串|
|data|object|-|是|传送参数的对象|
|+baseModel|int||否|基站的型号码|
|+modelName|string||否|基站的型号名称|
|+version|string||否|基站固件版本|
|+baseSN|string||否|基站SN|

- **示例代码**
```json
//连接成功
{
    "fun":"fEvtBsOnlineState",
    "dataTag":"1",
    "data":{       
        "baseModel":218,
        "modelName":"B200",
        "version":"1.0.3",
        "baseSN":"2024041401"
    }
}
```

### 基站授时
#### 方法
##### timeSync
- **主题**：/client/\${baseSN}/send
- **功能描述**：发送当前时间戳给基站进行校时
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|固定指令名称|
|dataTag|string|-|否|数据包标识|
|data|object|-|是|传送参数的对象|
|+timeStamp|long ||否|当前时间的时间戳|

- **示例代码**
```json
{
  "fun":"timeSync",
  "dataTag":"1",
  "data":{
      "timeStamp":1718247133290
  }
}
```
#### 事件
##### [sEvtStateCode](#sevtstatecode)
返回指令的接收状态

### 识别设置
#### 方法
##### getBsModel
- **主题**：/client/\${baseSN}/send
- **功能描述**：获取基站型号
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"getBsModel",
  "dataTag":"1"
}
```
##### getBsFWVersion
- **主题**：/client/\${baseSN}/send
- **功能描述**：获取基站固件版本
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"getBsFWVersion",
  "dataTag":"1"
}
```
#### 事件
##### fEvtBsSN
- **主题**: /basestation/\${baseSN}/receive
- **功能描述**：返回基站的出厂编码
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|事件名称|
|dataTag|string|-|否|数据包标识|
|data|object|-|是|传送参数的对象|
|+value|string|-|是|基站的出厂编码|

- **示例代码**
```json
{
    "fun":"fEvtBsSN",
    "dataTag":"1",
    "data":{
        "value":"2024041201"
    }
}
```
##### fEvtBsModel
- **主题**: /basestation/\${baseSN}/receive
- **功能描述**：返回基站的型号
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|事件名称|
|dataTag|string|-|否|数据包标识|
|data|object|-|是|传送参数的对象|
|+value|string|-|是|基站的型号名称|

- **示例代码**
```json
{
    "fun":"fEvtBsModel",
    "dataTag":"1",
    "data":{
        "value":"B200"
    }
}
```
##### fEvtBsFWVersion
- **主题**: /basestation/\${baseSN}/receive
- **功能描述**：返回基站的固件版本
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|事件名称|
|dataTag|string|-|否|数据包标识|
|data|object|-|是|传送参数的对象|
|+value|string||是|基站的固件版本号|

- **示例代码**
```json
{
    "fun":"fEvtBsFWVersion",
    "dataTag":"1",
    "data":{
        "value":"1.0.3"
    }
}
```
### 组网设置
#### 方法
##### getBsNetworkMode
- **主题**：/client/\${baseSN}/send
- **功能描述**：获取基站组网模式
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"getBsNetworkMode",
  "dataTag":"1"
}
```
##### getBsPairCode
- **主题**：/client/\${baseSN}/send
- **功能描述**：获取基站配对码
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"getBsPairCode",
  "dataTag":"1"
}
```
##### getBsNfcLogin
- **主题**：/client/\${baseSN}/send
- **功能描述**：获取刷卡配对状态
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"getBsNfcLogin",
  "dataTag":"1"
}
```
##### setBsNfcLogin
- **主题**：/client/\${baseSN}/send
- **功能描述**：设置基站刷卡配对状态
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+value|string|-|是|设置的基站刷卡配对状态<br>0-关闭刷卡配对<br>1-开启刷卡配对|

- **示例代码**
```json
{
  "fun":"setBsNfcLogin",
  "dataTag":"1",
  "data":{
    "value":"1"
  }
}
```
##### getBsChannel
- **主题**：/client/\${baseSN}/send
- **功能描述**：获取基站信道
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"getBsChannel",
  "dataTag":"1"
}
```
##### setBsChannel
- **主题**：/client/\${baseSN}/send
- **功能描述**：设置基站信道
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+value|string|-|是|设置的基站信道，可设范围：1-80|

- **示例代码**
```json
{
  "fun":"setBsChannel",
  "dataTag":"1",
  "data":{
    "value":"23"
  }
}
```

##### getBsRFIChannel
- **主题**：/client/\${baseSN}/send
- **功能描述**：获取已被其他基站占用的信道
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"getBsRFIChannel",
  "dataTag":"1"
}
```

#### 事件
##### fEvtBsNetworkMode
- **主题**: /basestation/\${baseSN}/receive
- **功能描述**：返回基站组网模式
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|事件名称|
|dataTag|string|-|否|数据包标识，可传空字符串|
|data|object|-|是|传送参数的对象|
|+value|string||是|基站的组网模式<br>1-配对模式<br>2-白名单模式|

- **示例代码**
```json
{
    "fun":"fEvtBsNetworkMode",
    "dataTag":"1",
    "data":{        
        "value":"1"
    }
}
```
##### fEvtBsPairCode
- **主题**: /basestation/\${baseSN}/receive
- **功能描述**：返回基站配对码
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|事件名称|
|dataTag|string|-|否|数据包标识，可传空字符串|
|data|object|-|是|传送参数的对象|
|+value|string||是|基站的配对码|

- **示例代码**
```json
{
    "fun":"fEvtBsPairCode",
    "dataTag":"1",
    "data":{        
        "value":"123456"
    }
}
```

##### fEvtBsChannel
- **主题**: /basestation/\${baseSN}/receive
- **功能描述**：返回基站信道
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|事件名称|
|dataTag|string|-|否|数据包标识，可传空字符串|
|data|object|-|是|传送参数的对象|
|+value|string||是|基站信道|

- **示例代码**
```json
{
    "fun":"fEvtBsChannel",
    "dataTag":"1",
    "data":{        
        "value":"5"
    }
}
```

##### fEvtBsRFIChannel
- **主题**: /basestation/\${baseSN}/receive
- **功能描述**：返回其他基站已占用的信道，频点冲突时，可以根据返回结果修改基站信道避开干扰
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|事件名称|
|dataTag|string|-|否|数据包标识，可传空字符串|
|data|object|-|是|传送参数的对象|
|+value|string||是|其他基站已占用的信道，多个信道用英文","分隔，无占用信道返回0|

- **示例代码**
```json
//信道1、2、14已被占用
{
    "fun":"fEvtBsRFIChannel",
    "dataTag":"1",
    "data":{        
        "value":"1,2,14"
    }
}
//无占用信道
{
    "fun":"fEvtBsRFIChannel",
    "dataTag":"1",
    "data":{        
        "value":"0"
    }
}
```

##### fEvtBsNfcLogin
- **主题**: /basestation/\${baseSN}/receive
- **功能描述**：返回基站是否允许NFC刷卡
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|事件名称|
|dataTag|string|-|否|数据包标识，可传空字符串|
|data|object|-|是|传送参数的对象|
|+value|string||是|0-关闭  1-开启|

- **示例代码**
```json
{
    "fun":"fEvtBsNfcLogin",
    "dataTag":"1",
    "data":{        
        "value":"1"
    }
}
```
### 登录设置
#### 方法
##### getBsSSID
获取基站登录名称
- **主题**：/client/\${baseSN}/send
- **功能描述**：获取基站登录名称
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|固定指令名称|
|dataTag|string|-|否|数据包标识|

- **示例代码**
```json
{
  "fun":"getBsSSID",
  "dataTag":"1"
}
```
##### setBsSSID
- **主题**：/client/\${baseSN}/send
- **功能描述**：设置基站登录名称
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+value|string||是|设置的基站SSID，最长12字符|

- **示例代码**
```json
{
  "fun":"setBsSSID",
  "dataTag":"1",
  "data":{
    "value":"1901班"
  }
}
```
##### getBsLoginPwd
- **主题**：/client/\${baseSN}/send
- **功能描述**：获取基站登录密码
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|固定指令名称|
|dataTag|string|-|否|数据包标识|

- **示例代码**
```json
{
  "fun":"getBsLoginPwd",
  "dataTag":"1"
}
```
##### setBsLoginPwd
- **主题**：/client/\${baseSN}/send
- **功能描述**：设置基站登录密码
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+value|string||是|设置的基站登录密码，数字类型，最长4位，为空或设为0代表无需密码登录|

- **示例代码**
```json
{
  "fun":"setBsLoginPwd",
  "dataTag":"1",
  "data":{
    "value":"1234"
  }
}
```
##### getBsLoginState
获取基站登录名称
- **主题**：/client/\${baseSN}/send
- **功能描述**：获取基站登录状态
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|固定指令名称|
|dataTag|string|-|否|数据包标识|

- **示例代码**
```json
{
  "fun":"getBsLoginState",
  "dataTag":"1"
}
```
##### setBsLoginState
- **主题**：/client/\${baseSN}/send
- **功能描述**：设置基站登录状态
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+value|string||是|设置是否允许键盘自主登入<br>0 - 不允许键盘登入<br>1 - 允许键盘登入|

- **示例代码**
```json
{
  "fun":"setBsLoginState",
  "dataTag":"1",
  "data":{
    "value":"1"
  }
}
```

#### 事件
##### fEvtBsSSID
- **主题**: /basestation/\${baseSN}/receive
- **功能描述**：返回基站名称
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|事件名称|
|dataTag|string|-|否|数据包标识，可传空字符串|
|data|object|-|是|传送参数的对象|
|+value|string||是|基站名称|

- **示例代码**
```json
{
    "fun":"fEvtBsSSID",
    "dataTag":"1",
    "data":{        
        "value":"1901班"
    }
}
```
##### fEvtBsLoginPwd
- **主题**: /basestation/\${baseSN}/receive
- **功能描述**：返回基站登录密码
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|事件名称|
|dataTag|string|-|否|数据包标识，可传空字符串|
|data|object|-|是|传送参数的对象|
|+value|string||是|基站登录密码，返回值为0代表无需密码登录|

- **示例代码**
```json
{
    "fun":"fEvtBsLoginPwd",
    "dataTag":"1",
    "data":{        
        "value":"1234"
    }
}

//无需密码登录
{
    "fun":"fEvtBsLoginPwd",
    "dataTag":"1",
    "data":{        
        "value":"0"
    }
}
```
##### fEvtBsLoginState
- **主题**: /basestation/\${baseSN}/receive
- **功能描述**：返回基站登录状态
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|事件名称|
|dataTag|string|-|否|数据包标识，可传空字符串|
|data|object|-|是|传送参数的对象|
|+value|string||是|基站登录状态|

- **示例代码**
```json
{
    "fun":"fEvtBsLoginState",
    "dataTag":"1",
    "data":{        
        "value":"1"
    }
}
```
### 键盘统一设置
#### 方法
##### getBsKpLanguage
- **主题**：/client/\${baseSN}/send
- **功能描述**：获取键盘语言
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"getBsKpLanguage",
  "dataTag":"1"
}
```
##### setBsKpLanguage
- **主题**：/client/\${baseSN}/send
- **功能描述**：设置键盘语言
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+value|string||是|设置键盘显示的语言<br>1-简体中文<br>2-英文|

- **示例代码**
```json
{
  "fun":"setBsKpLanguage",
  "dataTag":"1",
  "data":{
    "value":"1"
  }
}
```
#### 事件
##### fEvtBsKpLanguage
- **主题**: /basestation/\${baseSN}/receive
- **功能描述**：返回键盘语言
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+value|string||是|设置键盘显示的语言<br>1-简体中文<br>2-英文|

- **示例代码**
```json
{
  "fun":"fEvtBsKpLanguage",
  "dataTag":"1",
  "data":{
    "value":"1"
  }
}
```
### 配对模式
#### 方法
##### startBsFastPair
- **主题**：/client/\${baseSN}/send
- **功能描述**：启动快速配对,键盘配对成功返回键盘信息 [sEvtBsKpOnlineMsg](#sevtbskponlinemsg)
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"startBsFastPair",
  "dataTag":"1"
}
```
##### stopBsFastPair
- **主题**：/client/\${baseSN}/send
- **功能描述**：停止快速配对
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"stopBsFastPair",
  "dataTag":"1"
}
```
#### 事件
##### [sEvtStateCode](#sevtstatecode)
发送指令后返回此事件

##### [sEvtBsKpOnlineMsg](#sevtbskponlinemsg)
键盘配对成功后在线返回此事件

### 白名单模式
#### 方法
##### getBsWhitelist
- **主题**：/client/\${baseSN}/send
- **功能描述**：获取基站白名单列表
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"getBsWhitelist",
  "dataTag":"1"
}
```
##### setBsWhitelist
- **主题**：/client/\${baseSN}/send
- **功能描述**：设置基站白名单列表，将基站白名单替换为写入的键盘SN列表
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+keySns|array|-|是|待写入的键盘SN数组，最多不超过200<br>键盘SN为10位数字|

- **示例代码**
```json
{
  "fun":"setBsWhitelist",
  "dataTag":"1",
  "data":{
    "keySns":["2024021001","2024021002","2024021003","2024021004"]
  }
}
```
##### clearBsWhitelist
- **主题**：/client/\${baseSN}/send
- **功能描述**：清空基站白名单列表
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"clearBsWhitelist",
  "dataTag":"1"
}
```
##### addBsWhitelist
- **主题**：/client/\${baseSN}/send
- **功能描述**：添加键盘至基站白名单列表
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+keySns|array|-|是|待添加的键盘SN列表<br>键盘SN为10位数字|

- **示例代码**
```json
{
  "fun":"addBsWhitelist",
  "dataTag":"1",
  "data":{
    "keySns":["2024021001"]
  }
}
```
##### delBsWhitelist
- **主题**：/client/\${baseSN}/send
- **功能描述**：从基站白名单列表中删除键盘
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+keySns|array|-|是|待删除的键盘SN列表<br>键盘SN为10位数字|

- **示例代码**
```json
{
  "fun":"delBsWhitelist",
  "dataTag":"1",
  "data":{
    "keySns":["2024021001"]
  }
}
```
#### 事件
##### [sEvtStateCode](#sevtstatecode)
发送指令后返回此事件

##### fEvtBsWhitelist
- **主题**：/basestation/\${baseSN}/receive
- **功能描述**：返回基站白名单列表
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+keySns|array||是|基站当前的白名单列表|

- **示例代码**
```json
{
  "fun":"fEvtBsWhitelist",
  "dataTag":"1",
  "data":{
    "keySns":["2024021001","2024021002","2024021003","2024021004"]
  }
}
```

##### fEvtSetBsWhitelist
- **主题**：/basestation/\${baseSN}/receive
- **功能描述**：返回设置白名单状态
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|array|-|是|传送参数的对象数组|
|++keySns|array||是|键盘SN数组|
|++state|int||是|键盘SN的写入状态 <br>0-写入成功<br> 1-写入失败|

- **示例代码**
```json
{
  "fun":"fEvtSetBsWhitelist",
  "dataTag":"1",
  "data":[{
    "keySns":["2024021001","2024021002"],
    "state":0
  },{
    "keySns":["1211"],
    "state":1
  }]
}
```

##### fEvtAddBsWhitelist
- **主题**：/basestation/\${baseSN}/receive
- **功能描述**：返回增加键盘状态
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|array|-|是|传送参数的对象数组|
|++keySns|array||是|键盘SN数组|
|++state|int||是|键盘的增加状态 <br>0-增加成功<br> 1-增加失败|

- **示例代码**
```json
{
  "fun":"fEvtAddBsWhitelist",
  "dataTag":"1",
  "data":[{
    "keySns":["2024021001","2024021002"],
    "state":0
  },{
    "keySns":["1211"],
    "state":1
  }]
}
```

##### fEvtDelBsWhitelist
- **主题**：/basestation/\${baseSN}/receive
- **功能描述**：返回删除键盘状态
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|array|-|是|传送参数的对象数组|
|++keySns|array||是|键盘SN数组|
|++state|int||是|键盘的删除状态 <br>0-删除成功<br> 1-删除失败|

- **示例代码**
```json
{
  "fun":"fEvtDelBsWhitelist",
  "dataTag":"1",
  "data":[{
    "keySns":["2024021002"],
    "state":0
  },{
    "keySns":["2024021001"],
    "state":1
  }]
}
```

### 网络参数设置
#### 方法
##### getBsTcpipParams
- **主题**：/client/\${baseSN}/send
- **功能描述**：获取基站TCP/IP参数
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"getBsTcpipParams",
  "dataTag":"1"
}
```
##### setBsTcpipParams
- **主题**：/client/\${baseSN}/send
- **功能描述**：设置基站TCP/IP参数
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+ip|string||否|IP地址|
|+mask|string||否|子网掩码|
|+gateway|string||否|网关地址|
|+ipAllocation|int||否|基站IP获取方式<br>0 - 手动指定<br>1 - DHCP获取|

- **示例代码**
```json
{
  "fun":"setBsTcpipParams",
  "dataTag":"1",
  "data":{
    "ip":"192.168.0.10",
    "mask":"255.255.255.0",
    "gateway":"192.168.0.1",
    "ipAllocation":1
  }
}
```
##### getBsMqttParams
- **主题**：/client/\${baseSN}/send
- **功能描述**：获取基站MQTT参数
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"getBsMqttParams",
  "dataTag":"1"
}
```
##### setBsMqttParams
- **主题**：/client/\${baseSN}/send
- **功能描述**：设置基站MQTT参数
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+server|string||是|服务器IP地址|
|+port|int||是|端口，默认1883|
|+userName|string||否|连接服务器的用户名，可不设置|
|+password|string||否|连接服务器的密码，可不设置|
|+interval|int|>=30|否|基站连接服务器失败后重连的间隔时长，单位秒|

- **示例代码**
```json
{
  "fun":"setBsMqttParams",
  "dataTag":"1",
  "data":{
    "server":"192.168.10.10",
    "port":1883,
    "userName":"",
    "password":"",
    "interval":30
  }
}
```
#### 事件
##### fEvtBsTcpipParams
- **主题**: /basestation/\${baseSN}/receive
- **功能描述**：返回基站TCP/IP参数
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+mac|string||是|MAC地址|
|+ip|string||是|IP地址|
|+mask|string||是|子网掩码|
|+gateway|string||是|网关地址|
|+ipAllocation|int||否|基站IP获取方式<br>0 - 手动指定<br>1 - DHCP获取|

- **示例代码**
```json
{
  "fun":"fEvtBsTcpipParams",
  "dataTag":"1",
  "data":{
    "mac":"FF:FF:FF:FF:FF:FF",
    "ip":"192.168.0.10",
    "mask":"255.255.255.0",
    "gateway":"192.168.0.1",
    "ipAllocation":1
  }
}
```
##### fEvtBsMqttParams
- **主题**: /basestation/\${baseSN}/receive
- **功能描述**：返回基站MQTT参数
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+server|string||是|服务器地址，IP|
|+port|int||是|端口，默认1883|
|+userName|string||否|连接服务器的用户名，可不设置|
|+password|string||否|连接服务器的密码，可不设置|
|+interval|int|>=10|否|基站连接服务器失败后重连的间隔时长，单位秒|

- **示例代码**
```json
{
  "fun":"fEvtBsMqttParams",
  "dataTag":"1",
  "data":{
    "server":"192.168.10.10",
    "port":1883,
    "userName":"",
    "password":"",
    "interval":30
  }
}
```
### 基站加密
#### 方法
##### getBsSoftwareKey
- **主题**：/client/\${baseSN}/send
- **功能描述**：获取基站软件狗密钥
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"getBsSoftwareKey",
  "dataTag":"1"
}
```
##### setBsSoftwareKey
- **主题**：/client/\${baseSN}/send
- **功能描述**：设置基站软件狗密钥
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+value|string|-|是|基站软件狗密钥，长度不超过32字节|

- **示例代码**
```json
{
  "fun":"setBsSoftwareKey",
  "dataTag":"1",
  "data":{
    "value":"sunvote123456"
  }
}
```
#### 事件
##### fEvtBsSoftwareKey
- **主题**：/basestation/\${baseSN}/receive
- **功能描述**：返回基站的软件狗密钥
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+value|string||是|返回基站的软件狗密钥|

- **示例代码**
```json
{
  "fun":"fEvtBsSoftwareKey",
  "dataTag":"1",
  "data":{
    "value":"sunvote123456"
  }
}
```
## 键盘管理
### 交互设置
#### 方法
##### rtSetKpUserPrompt
- **主题**：/client/\${baseSN}/send
- **功能描述**：实时设置提示反馈信息
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|array|-|否|传送参数的对象数组|
|++keySns|array||是|指定的键盘SN数组，空数组表示全部在线键盘<br><font color="red">注意：不允许空数组和指定SN数组混合使用<br>包含空数组默认为全部在线键盘，其他指定键盘无效</font>|
|++info|string||否|设置的反馈信息<br>不同键盘可设置不同反馈信息|

- **示例代码**

```json
//分别提示
{
  "fun":"rtSetKpUserPrompt",
  "dataTag":"1",
  "data": [
    {
      "keySns": ["1479824643","1479824645"],
      "info": "答对了"
    },
    {
      "keySns": ["1479824644"],
      "info": "答错了"
    }
  ]
}
//统一提示
{
  "fun":"rtSetKpUserPrompt",
  "dataTag":"1",
  "data": [
    {
      "keySns": [],
      "info": "答题结束"
    }
  ]
}
```
#### 事件
##### [sEvtStateCode](#sevtstatecode)
发送指令后返回接收状态

##### fEvtSetKpUserPrompt
- **主题**：/basestation/\${baseSN}/receive
- **功能描述**：返回实时设置提示语是否成功
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|array|-|是|传送参数的对象数组|
|++keySn|string||是|设置提示语信息的键盘SN|
|++state|string||是|设置的提示语是否成功<br>0 - 成功<br>1 - 失败|

- **示例代码**

```json
{
  "fun":"fEvtSetKpUserPrompt",
  "dataTag":"1",
  "data": [
    {
      "keySn": "1479824643",
      "state": "0"
    },
    {
      "keySn": "1479824645",
      "state": "0"
    },
    {
      "keySn": "1479824644",
      "state": "1"
    }
  ]
}
```
### 在线状态
#### 方法
##### startGetKpOnline
- **主题**：/client/\${baseSN}/send
- **功能描述**：开始获取键盘在线信息,键盘在线返回键盘信息
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**

```json
{
  "fun":"startGetKpOnline",
  "dataTag":"1"
}
```

##### stopGetKpOnline
- **主题**：/client/\${baseSN}/send
- **功能描述**：停止获取键盘在线信息
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**

```json
{
  "fun":"stopGetKpOnline",
  "dataTag":"1"
}
```
#### 事件
##### [sEvtStateCode](#sevtstatecode)
发送指令后返回此事件

##### fEvtKpOnlineMsg
- **主题**: /basestation/\${baseSN}/receive
- **功能描述**：主动获取在线键盘时，在线键盘状态报告
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|事件名称|
|dataTag|string|-|否|数据包标识|
|data|object|-|是|传送参数的对象|
|+keySn|string||是|键盘SN|
|+version|string||是|键盘固件版本|
|+model|int||是|键盘型号|
|+voltage|double||是|键盘电量|

- **示例代码**
```json
{
    "fun":"fEvtKpOnlineMsg",
    "dataTag":"1",
    "data":{ 
        "keySn":"1234567890",
        "version":"1.0.0",
        "model":67,
        "voltage":2.8
    }
}
```

### 维护功能
#### 方法
##### remoteKpSleep
- **主题**：/client/\${baseSN}/send
- **功能描述**：遥控键盘休眠
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象数组|
|+keySns|array||否|需要执行指令的键盘SN数组，空数组表示所有键盘|

- **示例代码**
```json
{
  "fun":"remoteKpSleep",
  "dataTag":"1",
  "data":{
    "keySns":["1479824644"]
  }
}
```
#### 事件
##### [sEvtStateCode](#sevtstatecode)
返回指令的接收状态

## 绑定
### 无线绑定
#### 方法
##### rtSetKpBindingInfo
- **主题**：/client/\${baseSN}/send
- **功能描述**：实时设置绑定信息到键盘
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|array|-|是|传送参数的对象数组，不可为空|
|++keySn|string||是|需要设置绑定信息的键盘SN|
|++info|string||是|设置的绑定信息，一般为学生姓名<br>最长48个字符，显示在键盘左上角|

- **示例代码**

```json
{
  "fun":"rtSetKpBindingInfo",
  "dataTag":"1",
  "data": [
    {
      "keySn": "1479824643",
      "info": "张三"
    },
    {
      "keySn": "1479824644",
      "info": "李四"
    }
  ]
}
```

##### clearKpBindingInfo
- **主题**：/client/\${baseSN}/send
- **功能描述**：清除键盘绑定信息
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象数组|
|+keySns|array||否|需要清除绑定信息键盘SN数组，<br>空数组表示清空所有键盘|

- **示例代码**

```json
{
  "fun":"clearKpBindingInfo",
  "dataTag":"1",
  "data": {
    "keySns":["1479824643","1479824644","1479824645"]
  }
}
```
#### 事件
##### [sEvtStateCode](#sevtstatecode)
发送指令后返回接收状态

##### fEvtKpBindingInfo
- **主题**：/basestation/\${baseSN}/receive
- **功能描述**：返回键盘实时设置绑定信息的状态是否成功
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|array|-|否|传送参数的对象数组|
|++keySn|string||是|需要设置绑定信息的键盘SN|
|++state|string||是|设置的绑定信息是否成功<br>0 - 成功<br>1 - 失败|

- **示例代码**

```json
{
  "fun":"fEvtKpBindingInfo",
  "dataTag":"1",
  "data": [
    {
      "keySn": "1479824643",
      "state": "0"
    },
    {
      "keySn": "1479824644",
      "state": "1"
    }
  ]
}
```
##### fEvtClearKpBindingInfo
- **主题**：/basestation/\${baseSN}/receive
- **功能描述**：返回清空绑定信息的指令状态是否成功
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|否|传送参数的对象|
|+state|string||是|设置的绑定信息是否成功<br>0 - 成功<br>1 - 失败|

- **示例代码**

```json
{
  "fun":"fEvtClearKpBindingInfo",
  "dataTag":"1",
  "data": {
    "state": "0"
  }
}
```
## 签到
### 同步签到
#### 方法
##### startKpSignIn
- **主题**：/client/\${baseSN}/send
- **功能描述**：启动同步签到
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传递参数的对象|
|+mode|int|-|是|签到模式<br>1-按键签到，可指定按键<br>2-PIN码签到，可指定PIN码长度|
|+allowModify |int|-|是 | 修改模式 <br> 0-不可修改 <br>1-可以修改(默认值)|
|+pinLen |int|-|是| 可输入pin码的最大长度 1≤N≤14 |
|+keyValue |int|-|是 | 指定按键键值 <br> 0: 未指定(OK键签到) <br>1-9: 按键1-9 <br> 10: 按键0 <br> 11: 上键  <br> 12: 下键 <br> 13: OK键  <br> 14: ESC键  <br> 15: Menu键 |
|+tipTitle |string|-|否| 提示标题,长度最多不超过16个字节|

- **示例代码**
```json
//按键签到
{
  "fun":"startKpSignIn",
  "dataTag":"1",
  "data":{
    "mode":1,
    "allowModify":1,
    "keyValue":5,
    "tip":"请按5键签到"
  }
}

//pin签到
{
  "fun":"startKpSignIn",
  "dataTag":"1",
  "data":{
    "mode":2,
    "allowModify":1,
    "pinLen":6,
    "tip":"请输入PIN码签到"
  }
}
```
<!-- ##### stopKpSignIn
- **主题**：/client/\${baseSN}/send
- **功能描述**：停止同步签到
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"stopKpSignIn",
  "dataTag":"1"
}
``` -->
##### [stopKpVote](#stopkpvote)
停止同步签到

#### 事件
##### [sEvtStateCode](#sevtstatecode)
发送指令后返回接收状态

##### [fEvtKpSignIn](#fevtkpsignin)
返回键盘提交的签到数据

### 随时签到
#### 方法
##### rtStartKpSignIn
- **主题**：/client/\${baseSN}/send
- **功能描述**：启动随时签到绑定
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传递参数的对象|
|+mode|int|-|是|签到模式<br>2-PIN码签到，输入pin码后由应用程序决定是否授权|

- **示例代码**

```json
{
  "fun":"rtStartKpSignIn",
  "dataTag":"1",
  "data":{
    "mode":2
  }
}
```
##### rtStopKpSignIn
- **主题**：/client/\${baseSN}/send
- **功能描述**：停止随时签到绑定
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**

```json
{
  "fun":"rtStopKpSignIn",
  "dataTag":"1"
}
```
##### rtSetKpLoginAllowed
- **主题**：/client/\${baseSN}/send
- **功能描述**：实时PIN绑定授权,可取消授权
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传递参数的对象|
|+keySn|string|-|是|键盘SN|
|+state|int|-|是|1-授权成功<br>2-授权失败<br>3-解除已授权|

- **示例代码**

```json
{
  "fun":"rtSetKpLoginAllowed",
  "dataTag":"1",
  "data":{
    "keySn":"1479824643",
    "state":1
  }
}
```
#### 事件
##### [sEvtStateCode](#sevtstatecode)
发送指令后返回接收状态

##### fEvtKpSignIn
- **主题**：/basestation/\${baseSN}/receive
- **功能描述**：返回键盘提交签到信息
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|array|-|是|传送参数的对象数组|
|++keySn|string||是|键盘SN|
|++keyValue|string||是|键盘提交的按键值|
|++keyTime|double||是|答题时间，从启动开始计算，单位秒|
|++voltage|double||是|键盘电量|
|++retryCount|int||是|键盘提交数据的重发次数|

- **示例代码**

```json
{
  "fun":"fEvtKpSignIn",
  "dataTag":"1",
  "data": [{
      "keySn": "1234567890",
      "keyValue":"1004",
      "keyTime":30.2
    },
    {
      "keySn": "1234567891",
      "keyValue":"1003",
      "keyTime":32.5
    }
  ]
}
```
##### fEvtKpLoginAllowed
- **主题**：/basestation/\${baseSN}/receive
- **功能描述**：返回键盘授权状态
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+keySn|string||是|键盘SN|
|+state|string||是|0-执行成功<br> 1-执行失败|

- **示例代码**

```json
{
  "fun":"fEvtKpLoginAllowed",
  "dataTag":"1",
  "data": {
      "keySn":"1479824643",
      "state":"0"
    }
}
```
## 按键反馈
### 判断题
#### 方法
##### startQATrueFalse
- **主题**：/client/\${baseSN}/send
- **功能描述**：启动判断题答题
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+keySns|array||是|指定的键盘SN数组，空数组表示全部在线键盘|
|+count|int||是|题目数量，1-16，>1多题快答|
|+mode|int||是|1 - True/False 对/错 <br>2 - Yes/No 是/否<br> 3 - √/×|
|+allowModify|int||是|0 - 不允许修改<br>1 - 允许修改|
|+tip|string||否|提示的标题，长度不超过16字符|

- **示例代码**

```json
{
  "fun":"startQATrueFalse",
  "dataTag":"1",
  "data":{
    "keySns":[],
    "count":1,
    "mode":1,
    "allowModify":1,
    "tip":"请判断对错"
  }
}
```
<!-- ##### stopQATrueFalse
- **主题**：/client/\${baseSN}/send
- **功能描述**：停止判断题答题
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**

```json
{
  "fun":"stopQATrueFalse",
  "dataTag":"1"
}
``` -->

##### [stopKpVote](#stopkpvote)
停止判断题答题

#### 事件
##### [sEvtStateCode](#sevtstatecode)
发送指令后返回接收状态

##### fEvtQATrueFalse
- **主题**：/basestation/\${baseSN}/receive
- **功能描述**：返回键盘提交答题信息
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|array|-|是|传送参数的对象数组|
|++keySn|string||是|键盘SN|
|++keyValue|string||是|键盘提交的按键值<br>1-对<br>2-错|
|++keyTime|double||是|答题时间，从启动开始计算，单位秒|
|++voltage|double||是|键盘电量|
|++retryCount|int||是|键盘提交数据的重发次数|

- **示例代码**

```json
{
  "fun":"fEvtQATrueFalse",
  "dataTag":"1",
  "data": [{
      "keySn": "1234567890",
      "keyValue":"1",
      "keyTime":30.2
    }
  ]
}
```
### 选择题
#### 方法
##### startQAChoice
- **主题**：/client/\${baseSN}/send
- **功能描述**：启动选择题答题
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+keySns|array||是|指定的键盘SN数组，空数组表示全部在线键盘|
|+count|int||是|题目数量，1-16，>1多题快答<br>optionalN >1时无效|
|+mode|int||是|显示模式<br>1:显示字母(默认值) </br>2:显示数字 |
|+lessMode|int||是|迫选模式<br>0:可缺选(默认值) </br>1:不可缺选</br>2:允许重复输入</br>3:允许重复输入且不可缺选 |
|+options|int||是|选项数量，1≤M≤10(默认值4)|
|+optionalN|int||是|可选项个数，1≤N≤M(默认值1)|
|+allowModify|int||是|修改模式<br>0 - 不允许修改<br>1 - 允许修改|
|+tip|string||否|提示的标题，长度不超过16字符|

- **示例代码**

```json
{
  "fun":"startQAChoice",
  "dataTag":"1",
  "data":{
    "keySns":[],
    "mode": 1,
    "count":1,
    "lessMode": 0,
    "options": 4,
    "optionalN": 1,
    "allowModify":1,
    "tip":"请选择"
  }
}
```
<!-- ##### stopQAChoice
- **主题**：/client/\${baseSN}/send
- **功能描述**：停止选择题答题
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**

```json
{
  "fun":"stopQAChoice",
  "dataTag":"1"
}
``` -->
##### [stopKpVote](#stopkpvote)
停止选择题答题

#### 事件
##### [sEvtStateCode](#sevtstatecode)
发送指令后返回接收状态

##### fEvtQAChoice
- **主题**：/basestation/\${baseSN}/receive
- **功能描述**：返回键盘提交答题信息
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|array|-|是|传送参数的对象数组|
|++keySn|string||是|键盘SN|
|++keyValue|string||是|键盘提交的按键值|
|++keyTime|double||是|答题时间，从启动开始计算，单位秒|
|++voltage|double||是|键盘电量|
|++retryCount|int||是|键盘提交数据的重发次数|

- **示例代码**

```json
{
  "fun":"fEvtQAChoice",
  "dataTag":"1",
  "data": [{
      "keySn": "1234567890",
      "keyValue":"A",
      "keyTime":3.2
    }]
}
```
### 数字题
#### 方法
##### startQANum
- **主题**：/client/\${baseSN}/send
- **功能描述**：启动数字题答题
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+keySns|array||是|指定的键盘SN数组，空数组表示全部在线键盘|
|+mode|int||是|模式<br>0:无规则 （S6最多16位，T2最多14位）<br>1:带小数位上下限（T2不支持）|
|+digits|int||是|小数位数,范围0-2，mode=1时有效
|+numMin|int||是|可输入下限,mode=1有效，范围0-100|
|+numMax|int||是|可输入上限,mode=1有效，范围0-100|
|+allowModify|int||是|修改模式<br>0 - 不允许修改<br>1 - 允许修改|
|+tip|string||否|提示的标题，长度不超过16字符|

- **示例代码**

```json
{
  "fun":"startQANum",
  "dataTag":"1",
  "data":{
    "keySns":[],
    "mode": 1,
    "digits": 1,
    "numMin": 0,
    "numMax": 100,
    "allowModify":1,
    "tip":"请输入数字"
  }
}
```
<!-- ##### stopQANum
- **主题**：/client/\${baseSN}/send
- **功能描述**：停止数字题答题
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**

```json
{
  "fun":"stopQANum",
  "dataTag":"1"
}
``` -->
##### [stopKpVote](#stopkpvote)
停止数字题答题

#### 事件
##### [sEvtStateCode](#sevtstatecode)
发送指令后返回接收状态

##### fEvtQANum
- **主题**：/basestation/\${baseSN}/receive
- **功能描述**：返回键盘提交答题信息
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|array|-|是|传送参数的对象数组|
|++keySn|string||是|键盘SN|
|++keyValue|string||是|键盘提交的按键值|
|++keyTime|double||是|答题时间，从启动开始计算，单位秒|
|++voltage|double||是|键盘电量|
|++retryCount|int||是|键盘提交数据的重发次数|

- **示例代码**

```json
{
  "fun":"fEvtQANum",
  "dataTag":"1",
  "data":[{
      "keySn": "1234567890",
      "keyValue":"10",
      "keyTime":3.2
    }]
}
```
### 抢答题
#### 方法
##### startQAQuicker
- **主题**：/client/\${baseSN}/send
- **功能描述**：启动抢答题答题
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+keySns|array||是|指定的键盘SN数组，空数组表示全部在线键盘|
|+mode|int||是|模式<br>0:普通抢答|
|+allowModify|int||是|修改模式<br>0 - 不允许修改<br>1 - 允许修改|
|+tip|string||否|提示的标题，长度不超过16字符|

- **示例代码**

```json
{
  "fun":"startQAQuicker",
  "dataTag":"1",
  "data":{
    "keySns":[],
    "mode": 0,
    "allowModify":1,
    "tip":"请按键抢答"
  }
}
```
<!-- ##### stopQAQuicker
- **主题**：/client/\${baseSN}/send
- **功能描述**：停止抢答答题
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**

```json
{
  "fun":"stopQAQuicker",
  "dataTag":"1"
}
``` -->

##### [stopKpVote](#stopkpvote)
停止抢答

#### 事件
##### [sEvtStateCode](#sevtstatecode)
发送指令后返回接收状态

##### fEvtQAQuicker
- **主题**：/basestation/\${baseSN}/receive
- **功能描述**：返回键盘提交答题信息
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|array|-|是|传送参数的对象数组|
|++keySn|string||是|键盘SN|
|++keyValue|string||是|键盘提交的按键值|
|++keyTime|double||是|答题时间，从启动开始计算，单位秒|
|++voltage|double||是|键盘电量|
|++retryCount|int||是|键盘提交数据的重发次数|

- **示例代码**

```json
{
  "fun":"fEvtQAQuicker",
  "dataTag":"1",
  "data": [{
      "keySn": "1234567890",
      "keyValue":"1",
      "keyTime":3.2
    }]
}
```
### 待机实时反馈
#### 方法
##### setKpStbResponse
- **主题**：/client/\${baseSN}/send
- **功能描述**：启动待机实时反馈
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+state|int||是|启用待机实时反馈<br>0-不启用<br>1-启用|
|+mode|int||是|启动待机反馈类型，state=1时有效<br>1 - 指定按键反馈|
|+keys|int||是|有效按键数量，state=1且mode=1时有效, 范围1-10|

- **示例代码**
```json
//启用待机按键反馈
{
  "fun":"setKpStbResponse",
  "dataTag":"1",
  "data":{
    "state":1,
    "mode":1,
    "keys":4
  }
}
//关闭待机按键反馈
{
  "fun":"setKpStbResponse",
  "dataTag":"1",
  "data":{
    "state":0
  }
}
```

##### getKpStbResponse
- **主题**：/client/\${baseSN}/send
- **功能描述**：获取实时反馈是否打开
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
//获取实时反馈状态
{
  "fun":"getKpStbResponse",
  "dataTag":"1"
}
```

#### 事件
##### fEvtKpStbResponse
- **主题**：/basestation/\${baseSN}/receive
- **功能描述**：返回当前待机按键反馈开启状态
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|array|-|是|传送参数的对象数组|
|+state|int||是|启用待机实时反馈<br>0-未启用<br>1-启用|
|+mode|int||是|当前启动待机反馈类型，state=1时返回<br>0-举手<br>1-指定按键反馈|

- **示例代码**
```json
//当前启用待机实时反馈，模式为指定按键反馈
{
  "fun":"fEvtKpStbResponse",
  "dataTag":"1",
  "data": {
    "state": 1,
    "mode": 1
  }
}

//当前未启用待机反馈
{
  "fun":"fEvtKpStbResponse",
  "dataTag":"1",
  "data": {
    "state": 0
  }
}
```

##### [sEvtKpRtFeedback](#sevtkprtfeedback)
返回待机时键盘返回的按键值

##### [sEvtKpHandup](#sevtkphandup)
启动待机按键反馈类型为举手提问时返回此事件

## 在线测验
### 标准测验
#### 方法
##### startKpExam
- **主题**：/client/\${baseSN}/send
- **功能描述**：启动标准测验
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+examNo|int||是|0-9999<br>=0，新的测验<br>>0时,与上次启动卷号一致继续测验，不一致进入新的测验|
|+mode|int||是|显示模式<br>0-不显示开头<br>1-显示“Q”开头<br>2-显示“题”开头|
|+questions|array||是|题目详情|
|++quesType | int||是| 题目类型<br>1:单选<br>2:多选（排序）<br>3:数字<br>4:判断 |
|++option |int||是 |选项数目<br> quesType = 1 有效。<br>quesType = 2 有效。<br>此项缺省时  默认4;<br>范围：1-10。|
|++startNo | string||是| 起始题号,可以为数字+“-”，单级的题号数字范围1-255，如“1”，“1-1”，“1-1-1”，最多只能输入三级<br>mode=0 时有效，mode=1或2时键盘按顺序显示题号|
|++count | int||是| 相同参数的连续题目数量, >0 <br>注意：总题数最多支持200题 |

- **示例代码**

**常用样例**：一级题型 + 显示“Q”开头, 单一题型，全单选题共10题
```json
{
  "fun":"startKpExam",
  "dataTag":"1",
  "data":{
    "mode": 1,
    "examNo": 0,
    "questions": [{          
        "quesType": 1,  //单选题
        "startNo": "1",  //题号从1开始
        "count":10  //连续10题
      }]
  }
}
```

指令样例：一级题型 + 不显示开头，总题数6题
```json
{
  "fun":"startKpExam",
  "dataTag":"1",
  "data":{
    "mode": 0,
    "examNo": 0,
    //第1、2题单选题，第3、4题多选题，第5题数字，第6题判断，共6题
    "questions": [{ 
        "quesType": 1,  //单选题
        "startNo": "1",  //题号从1开始
        "count":2  //连续2题
      },{
        "quesType": 2,  //多选题
        "startNo": "3",  //题号从3开始
        "count":2,  //连续2题
        "option":5   
      },{
        "quesType": 1,  //数字题
        "startNo": "5",  //题号从5开始
        "count":1  //连续1题
      },{
        "quesType": 4,  //判断题
        "startNo": "6",  //题号从6开始
        "count":1  //连续1题
      }]
  }
}
```

指令样例：二级题型 + 不显示开头，总题数6题
```json
{
  "fun":"startKpExam",
  "dataTag":"1",
  "data":{
    "mode": 0,
    "examNo": 0,
    //第1-1、1-2题单选题，第2-1、2-2题多选题，第3-1题数字，第4-1题判断，共6题
    "questions": [{  
        "quesType": 1,  //单选题
        "startNo": "1-1",  //题号从1-1开始
        "count":2  //连续2题
      },{
        "quesType": 2,  //多选题
        "startNo":"2-1",  //题号从2-1开始
        "count":2,  //连续2题
        "option":5 
      },{
        "quesType": 3,  //数字题
        "startNo":"3-1",  //题号从3-1开始
        "count":1  //连续1题
      },{
        "quesType": 4,  //判断题
        "startNo": "4-1",  //题号从4-1开始
        "count":1  //连续1题
      }]
  }
}
```

指令样例：三级题型 + 不显示开头，总题数6题
```json
{
  "fun":"startKpExam",
  "dataTag":"1",
  "data":{
    "mode": 0,
    "examNo": 0,
    //第1-1-1、1-1-2题单选题，第1-2-1、1-2-2题多选题，第2-1-1题数字，第3-1-1题判断，共6题
    "questions": [{        
        "quesType": 1,  //单选题
        "startNo": "1-1-1",  //题号从1-1-1开始
        "count":2  //连续2题
      },{
        "quesType": 2,  //多选题
        "startNo": "1-2-1",  //题号从1-2-1开始
        "count":2,  //连续2题
        "option":5 
      },{
        "quesType": 3,  //数字题
        "startNo": "2-1-1",  //题号从2-1-1开始
        "count":1  //连续1题
      },{
        "quesType": 4,  //判断题
        "startNo": "3-1-1",  //题号从3-1-1开始
        "count":1  //连续1题
      }]
  }
}
```

指令样例：一级题型 + 显示“Q”开头, 共6题
```json
{
  "fun":"startKpExam",
  "dataTag":"1",
  "data":{
    "mode": 1,
    "examNo": 0,
    "questions": [{  
        "quesType": 1,  //单选题
        "startNo": "1",  //题号从1开始
        "count":2  //连续2题
      },{
        "quesType": 2,  //多选题
        "startNo": "3",  //题号从3开始
        "count":2,  //连续2题
        "option":5   
      },{
        "quesType": 1,  //数字题
        "startNo": "5",  //题号从5开始
        "count":1  //连续1题
      },{
        "quesType": 4,  //判断题
        "startNo": "6",  //题号从6开始
        "count":1  //连续1题
      }]
  }
}
```

指令样例：一级题型 + 显示“题”开头, 共6题
```json
{
  "fun":"startKpExam",
  "dataTag":"1",
  "data":{
    "mode": 2,
    "examNo": 0,
    "questions": [{  
        "quesType": 1,  //单选题
        "startNo": "1",  //题号从1开始
        "count":2  //连续2题
      },{
        "quesType": 2,  //多选题
        "startNo": "3",  //题号从3开始
        "count":2,  //连续2题
        "option":5   
      },{
        "quesType": 1,  //数字题
        "startNo": "5",  //题号从5开始
        "count":1  //连续1题
      },{
        "quesType": 4,  //判断题
        "startNo": "6",  //题号从6开始
        "count":1  //连续1题
      }]
  }
}
```

<!-- ##### stopKpExam
- **主题**：/client/\${baseSN}/send
- **功能描述**：停止标准测验
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**

```json
{
  "fun":"stopKpExam",
  "dataTag":"1"
}
``` -->
##### [stopKpVote](#stopkpvote)
停止在线测验

##### rtKpAllowEdited
- **主题**：/client/\${baseSN}/send
- **功能描述**：键盘提交后，允许键盘修改答案
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+keySns|array||是|指定的键盘SN数组，空数组表示全部在线键盘|

- **示例代码**

```json
{
  "fun":"rtKpAllowEdited",
  "dataTag":"1",
  "data":{
    "keySns":["1234567890","1234567891"]
  }
}
```
#### 事件
##### [sEvtStateCode](#sevtstatecode)
发送指令后返回接收状态

##### fEvtKpExam
- **主题**：/basestation/\${baseSN}/receive
- **功能描述**：返回键盘提交答题信息
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|array|-|是|传送参数的对象数组|
|++keySn|string||是|键盘SN|
|++keyValue|string||是|键盘提交的按键值,1:A;2:B表示第1题提交A，第二题提交B<br><font color="red">注意：如启动的是多科测验，键盘提交的题目序号对应启动时下发的题目总序号，不按科目区分</font>|
|++keyTime|double||是|答题时间，从启动开始计算，单位秒|
|++voltage|double||是|键盘电量|
|++retryCount|int||是|键盘提交数据的重发次数|

- **示例代码**

```json
{
  "fun":"fEvtKpExam",
  "dataTag":"1",
  "data": [{
      "keySn": "1234567890",
      "keyValue":"1:A;2:B",
      "keyTime":3.2
    },
    {
      "keySn": "1234567891",
      "keyValue":"1:B;2:B",
      "keyTime":3.5
    }
  ]
}
```
##### fEvtFinalSubmit
- **主题**：/basestation/\${baseSN}/receive
- **功能描述**：返回键盘手动交卷标识
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|array|-|是|传送参数的对象数组|
|++keySn|string||是|键盘SN|
|++keyValue|string||是|0 - 未提交(提交完成后，允许键盘修改答案时上报)<br>1 - 已交卷|
|++keyTime|double||是|提交时间，从启动开始计算，单位秒|

- **示例代码**

```json
{
  "fun":"fEvtFinalSubmit",
  "dataTag":"1",
  "data": [{
      "keySn": "1234567890",
      "keyValue":"1",
      "keyTime":3.2
    }]
}
```

### 多科测验
#### 方法
##### startKpMultiExam
- **主题**：/client/\${baseSN}/send
- **功能描述**：启动多科测验
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+examNo|int||是|0-9999<br>=0，新的测验<br>>0时,与上次启动卷号一致继续测验，不一致进入新的测验|
|+mode|int||是|显示模式<br>0-不显示开头<br>1-显示“Q”开头<br>2-显示“题”开头|
|+questions|array||是|题目详情|
|++subject | int||是 | 科目序号,1-9,对应键盘中内置的科目1-9<br>键盘答题时可选择科目切换答题|
|++quesType | int||是| 题目类型<br>1:单选<br>2:多选（排序）<br>3:数字<br>4:判断 |
|++option |int||是 |选项数目<br> quesType = 1 有效。<br>quesType = 2 有效。<br>此项缺省时  默认4;<br>范围：1-10。|
|++startNo | string||是| 起始题号,可以为数字+“-”，单级的题号数字范围1-255，如“1”，“1-1”，最多支持两级题号<br>mode=0 时有效，mode=1或2时键盘按顺序显示题号|
|++count | int||是| 相同参数的连续题目数量, >0 <br>注意：所有科目的总题数最多支持200题|
|+simParams|object||否|内部模拟测试参数设置对象|
|++answer|array||是|预设提交的按键值<br>格式为"单选题答案,多选题答案;<br>数字题答案;判断题答案(1对2错)"<br>如["A","ABCD","10","1"]|

- **示例代码**
```json
//自定义题号
{
  "fun":"startKpMultiExam",
  "dataTag":"1",
  "data":{
    "mode": 0,
    "examNo": 0,
    "questions": [{
        "subject":1,   //科目1
        //题号1-1 到1-10 共10题单选
        "quesType": 1,
        "startNo": "1-1",
        "count":10
      }, {
        "subject":2,   //科目2
        //题号2-2和2-3共两题 多选题，5个选项
        "quesType": 2,
        "option": 5,
        "startNo": "2-2",
        "count":2
      }, {
        "subject":3,   //科目3
        //题号3-1和3-2共两道数字题
        "quesType": 3,
        "startNo": "3-1",
        "count":2
      }, {
        "subject":1,   //科目1
        //题号4和5 ，判断题
        "quesType": 4,
        "startNo": "4",
        "count":2
      }]
  }
}

//显示Q开头
{
  "fun":"startKpMultiExam",
  "dataTag":"1",
  "data":{
    "mode": 1,
    "examNo": 0,
    "questions": [{
        "subject":1,
        //Q1-Q20,单选题
        "quesType": 1,
        "startNo": "1",
        "count":20
      }]
  }
}

//显示题开头
{
  "fun":"startKpMultiExam",
  "dataTag":"1",
  "data":{
    "mode": 2,
    "examNo": 0,
    "questions": [{
        "subject":1,
        //题1-题20,单选题
        "quesType": 1,
        "startNo": "1",
        "count":20
      }]
  }
}
```

<!-- ##### stopKpMultiExam
- **主题**：/client/\${baseSN}/send
- **功能描述**：停止多科测验
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"stopKpMultiExam",
  "dataTag":"1"
}
``` -->
##### [stopKpVote](#stopkpvote)
停止多科测验

#### 事件
##### [sEvtStateCode](#sevtstatecode)
发送指令后返回接收状态

##### [fEvtKpExam](#fevtkpexam)
返回测验中键盘提交答题数据

##### [fEvtFinalSubmit](#fevtfinalsubmit)
返回键盘手动交卷标识

### 自主录分
#### 方法
##### startKpScoreInput
- **主题**：/client/\${baseSN}/send
- **功能描述**：启动自主录分
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|object|-|是|传送参数的对象|
|+examNo|int||是|0-9999<br>=0，新的录分<br>>0时,与上次启动卷号一致继续录分，不一致进入新的录分|
|+mode|int||是|录分模式<br>0-自主录分<br>1-交叉录分，需先输入录分的人员标识|
|+questions|array||是|题目详情|
|++max |int||是|可输入的最大值，<=100|
|++digits|int||是|可输入的小数位数，范围0-2|
|++startNo | string||是| 起始题号，暂只支持一级题号，范围1-255|
|++count | int||是| 相同参数的题目数量，>0<br>注意：总题数最多支持200题|

- **示例代码**
```json
{
  "fun":"startKpScoreInput",
  "dataTag":"1",
  "data":{
    "mode": 0,
    "examNo": 0,
    "questions": [{
      //题号1 到 2 共2题,单题满分10分
      "max":10,
      "digits":1,
      "startNo": "1",
      "count":2
    }, {
      //题号3到6 共4道题，单题满分5
      "max":5,
      "digits":0,
      "startNo": "3",
      "count":4
    }]
  }
}
```
<!-- 
##### stopKpScoreInput
- **主题**：/client/\${baseSN}/send
- **功能描述**：停止自主录分
- **参数说明**

|参数名|类型|限制|是否必填|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|

- **示例代码**
```json
{
  "fun":"stopKpScoreInput",
  "dataTag":"1"
}
``` -->
##### [stopKpVote](#stopkpvote)
停止自主录分

#### 事件
##### [sEvtStateCode](#sevtstatecode)
发送指令后返回接收状态

##### fEvtKpScore
- **主题**：/basestation/\${baseSN}/receive
- **功能描述**：返回键盘提交录分信息
- **参数说明**

|参数名|类型|限制|非空|说明|
|---|---|---|---|---|
|fun|string|-|是|指令名称|
|dataTag|string|-|否|数据包标识,可为空字符串|
|data|array|-|是|传送参数的对象数组|
|++keySn|string||是|键盘SN|
|++keyValue|string||是|键盘提交的分值,1:10;2:0表示第1题提交10分，第二题提交0分|
|++keyTime|double||是|录分时间，从启动录分开始计算，单位秒|
|++voltage|double||是|键盘电量|
|++retryCount|int||是|键盘提交数据的重发次数|

- **示例代码**
```json
{
  "fun":"fEvtKpScore",
  "dataTag":"1",
  "data": [{
      "keySn": "1234567890",
      "keyValue":"1:8;2:7.5;3:2;4:3",
      "keyTime":3.2
    },
    {
      "keySn": "1234567891",
      "keyValue":"1:10;2:0",
      "keyTime":3.5
    }
  ]
}
```